{*
* 2007-2013 EXPERT SOLUTIONS
*
* NOTICE OF LICENSE
* ALL RIGHT RESERVED TO EXPERT SOLUTIONS SARL

*  @author Expert Solutions SARL <contact@expert-solutions.fr>
*  @copyright  2013 EXPERT SOLUTIONS SARL
*  @license    proprietary
*
* FRONT 
*}
{if $product->options->colors != 'hidden'}
<h3>{l s='Color & Inks' mod='clariprint'} :</h3>
<div>
	{if $product->options->colors == 'fixed'} 
		{foreach from=$product->front_colors item=c}
			<input type="hidden" name="{$product_key}[front_colors][]" value="{$c}" />
		{/foreach}
		{foreach from=$product->back_colors item=c}
			<input type="hidden" name="{$product_key}[back_colors][]" value="{$c}" />
		{/foreach}
	<ul>
		<li>{l s='Front colors:' mod='clariprint'}</li>
		<li>{l s='Back colors:' mod='clariprint'}</li>
	</ul>

	{elseif $product->options->colors == 'onelist'}

		{assign var=rcolors value="\n"|explode:$product->options->front_colors}

		<select name="{$product_key}[colors]">
			{foreach from=$rcolors item=c}
			{assign var=col value=':'|explode:$c:2}
			<option value="{$col[0]}">{$col[1]}</option>
			{/foreach}
		</select>
	
	{elseif $product->options->colors == 'list'} 
		{assign var=rcolors value="\n"|explode:$product->options->font_colors}
		<select name="{$product_key}[front_colors][]" class="">
			{foreach from=$rcolors item=c}
			<option value="{$c}">{$c}</option>
			{/foreach}
		</select>
		<div class="Clariprint_PMS">
			
		</div>
	{elseif $product->options->colors == 'simple'} 
		<label for="{$product_key}_colors">{l s='Front printed colors:'  mod='clariprint'}</label>
		<select name="{$product_key}[front_colors][]">
			<option value="black" {if in_array_silent('black',$product->front_colors)}checked{/if}>{l s='black' mod='clariprint'}</option>
			<option value="4color" {if in_array_silent('4color',$product->front_colors)}checked{/if}>{l s='4 color' mod='clariprint'}</option>
		</select>
		<div class="clear"></div>

		{if isset($product->back_colors)}
		<label for="{$product_key}_colors">{l s='Back printed colors:'  mod='clariprint'}</label>
		<select name="{$product_key}[back_colors][]">
			<option value="">{l s='none' mod='clariprint'}</option>
			<option value="black" {if in_array_silent('black',$product->back_colors)}checked{/if}>{l s='black' mod='clariprint'}</option>
			<option value="4color" {if in_array_silent('4color',$product->back_colors)}checked{/if}>{l s='4 color' mod='clariprint'}</option>
		</select>
		{/if}
	{else}
	<table id='{$product_key}_colors_table'>
		<thead>
			<tr>
				<th>{l s='colors' mod='clariprint'}</th>
				<th>{l s='cyan' mod='clariprint'}</th>
				<th>{l s='magenta' mod='clariprint'}</th>
				<th>{l s='yellow' mod='clariprint'}</th>
				<th>{l s='black' mod='clariprint'}</th>
				<th>{l s='quadri' mod='clariprint'}</th>
				{for $i=1 to 4}
					{assign var=color value="pms$i"}
					{if (in_array_silent($color,$product->options->colors_available))}
				<th>{l s='special tone' mod='clariprint'}</th>
					{/if}
				{/for}
			</tr>
		</thead>
		<tbody>
			<tr>
				<th>{l s='Kind' mod='clariprint'}</th>
				<td colspan="5">{l s='primary' mod='clariprint'}</td>
				{for $i=1 to 4}
					{assign var=color value="pms$i"}
					{if (in_array_silent($color,$product->options->colors_available))}
				<td>
					<select name="{$product_key}[{$color}][class]" style="width: 70px;">
						<option value="PMS" {if ($product->$color->class == "PMS")}selected{/if} >{l s='Pantone' mod='clariprint'}</option>
						<option value="Metal" {if ($product->$color->class == "Metal")}selected{/if}>{l s='Metallic' mod='clariprint'}</option>
						<option value="Spot" {if ($product->$color->class == "Spot")}selected{/if}>{l s='Spot' mod='clariprint'}</option>
					</select>
				</td>
					{/if}
				{/for}
			</tr>
			<tr class="ClariprintColorWidget">
				<th>{l s='Front colors' mod='clariprint'}</th>
				{foreach from=$primaries item=c}
				<td>
					{if in_array_silent($c,$product->options->colors_available)}
					<input type="checkbox" class="CLColor frontcolor primary" id='bob' name="{$product_key}[front_colors][]" value="{$c}" {if in_array_silent($c,$product->front_colors)}checked{/if} />
					{else}
					<input type="checkbox" disabled name="{$product_key}[front_colors][]" value="{$c}" {if in_array_silent($c,$product->front_colors)}checked{/if} />
					{/if}
				</td>
				{/foreach}

				{for $i=1 to 4}
					{assign var=color value="pms$i"}
				<td>
					{if (in_array_silent($color,$product->options->colors_available))}
						<input type="checkbox" name="{$product_key}[{$color}][front]" value="{$color}" {if $product->$color->front}checked{/if} />
					{else}
						<input type="hidden" name="{$product_key}[{$color}][front]" value="{$color}" {if  $product->$color->front}checked{/if} />
					{/if}
				</td>
				{/for}
			</tr>

			<tr id='bob2' class="ClariprintColorWidget">
				<th>{l s='Back colors' mod='clariprint'}</th>
				{foreach from=$primaries item=c}
				<td>
					{if in_array_silent($c,$product->options->colors_available)}
					<input type="checkbox" class="CLColor frontcolor primary" id='bob' name="{$product_key}[back_colors][]" value="{$c}" {if in_array_silent($c,$product->front_colors)}checked{/if} />
					{else}
					<input type="checkbox" disabled  name="{$product_key}[back_colors][]" value="{$c}" {if in_array_silent($c,$product->front_colors)}checked{/if}  />
					{/if}
				</td>
				{/foreach}
				{for $i=1 to 4}
					{assign var=color value="pms$i"}
				<td>
					{if (in_array_silent($color,$product->options->colors_available))}
						<input type="checkbox" name="{$product_key}[{$color}][back]" value="{$color}" {if $product->$color->back}checked{/if} />
					{else}
						<input type="hidden" name="{$product_key}[{$color}][back]" value="{$color}" {if  $product->$color->back}checked{/if} />
					{/if}
				</td>
				{/for}
			</tr>
		</tbody>
	</table>
	{/if}
	{if $product->options->pms}
	<label>{l s='Special colors' mod='clariprint'}</label>
	<table id='{$product_key}_colors_table'>
		<thead>
			<tr>
				<th>{l s='colors' mod='clariprint'}</th>
				{foreach from=$sepcial_colors item=pms}
				<th>
					<select name="{$product_key}[{$pms}][class]" style="width: 70px;">
						<option value="PMS" {if ($product->$pms->class == "PMS")}selected{/if} >{l s='Pantone' mod='clariprint'}</option>
						<option value="Metal" {if ($product->$pms->class == "Metal")}selected{/if}>{l s='Metallic' mod='clariprint'}</option>
						<option value="Spot" {if ($product->$pms->class == "Spot")}selected{/if}>{l s='Spot' mod='clariprint'}</option>
					</select>
					<input size="3" name="{$product_key}[{$pms}][code]" value="{$product->$pms->code|Default:'{$pms}'}" type="text"></td>
				</th>
				{/foreach}
			</tr>
		</thead>
		<tbody>
			<tr>
				<th>{l s='Front colors'}</th>
				{foreach from=array('pms1','pms2','pms3','pms4') item=pms}
				<td><input name="{$product_key}[{$pms}][recto]" value="1" type="checkbox" {if ($product->$pms->recto)}checked{/if}/></td>
				{/foreach}
			</tr>
			
			<tr>
				<th>{l s='Back colors'}</th>
				{foreach from=array('pms1','pms2','pms3','pms4') item=pms}
				<td><input name="{$product_key}[{$pms}][verso]" value="1" type="checkbox" {if ($product->$pms->recto)}checked{/if}/></td>
				{/foreach}
			</tr>
		</tbody>	
	</table>
	{/if}
	{if $product->options->colors_info}
	<div class="info success">{$product->options->colors_info}</div>
	{/if}
</div>
{else}
	{foreach from=$product->front_colors item=color}
		<input type="hidden" name="{$product_key}[front_colors][]" value="{$color}"/>
	{/foreach}
	{foreach from=$product->back_colors item=color}
		<input type="hidden" name="{$product_key}[back_colors][]" value="{$color}"/>
	{/foreach}
	{for $i=1 to 4}
		{assign var=color value="pms$i"}
		{if $product->$color}
			<input type="hidden" name="{$product_key}[{$color}][code]" value="{$product->$color->code}"/>
			<input type="hidden" name="{$product_key}[{$color}][back]" value="{$product->$color->back}"/>
			<input type="hidden" name="{$product_key}[{$color}][front]" value="{$product->$color->front}"/>
		{/if}
	{/for}
{/if}
