<?php

require_once dirname(__FILE__).'/../../classes/clariprintconnect.php';
require_once dirname(__FILE__).'/../../classes/clariprintconnect.php';
require_once dirname(__FILE__).'/../../classes/clariprintmargin.php';

class ClariprintSolverModuleFrontController extends ModuleFrontController
{
	public function displayAjaxPriceRequest()
	{
		if ($res = $this->callClariprint(Tools::getValue('product'),!Tools::isSubmit('no_cache')))
		{
			if ($res->success) {
	/*			$address = Address::initialize();
				$tax_manager = TaxManagerFactory::getManager($address, $this->id_tax_rules_group);
				$tax_calculator = $tax_manager->getTaxCalculator();
				$rate = $tax_calculator->getTotalRate() ; */
			

				$v = $res->response;
				if (isset($res->costs))
				{
					if ($costs = $res->costs)
					{

						if (!Tools::isSubmit('nodiscount'))
							$res->costs = ClariprintMargin::applyForCustomer(null,$costs->paper,$costs->print,$costs->makeready,$costs->packaging,$costs->delivery);
						else 
							$res->costs = ClariprintMargin::applyForGroup(1,$costs->paper,$costs->print,$costs->makeready,$costs->packaging,$costs->delivery);
				
						$res->response = $res->costs['total'];
						$v = (float)$res->costs['total'];

						if ($res->costs['discount'] != 0)
						{
							$res->responseTxt = Tools::displayPrice($v, null) . sprintf(' HT (%.2f%%)',$res->costs['discount']); 
						} else $res->responseTxt = Tools::displayPrice($v, null) . ' HT'; 
					}
				} else  $res->responseTxt = Tools::displayPrice($v, null) . ' HT'; 

				$res->priceHT = Tools::displayPrice($v, null); 
				$res->priceTTC = Tools::displayPrice($v * 1.2 , null); //[TODO] mettre la bonne taxe xp 
				$cookie = Context::getContext()->cookie;
				$cookie->last_clariprint_call = $v;
			}
		}
		echo Tools::jsonEncode($res);
	}

	public static function createTables()
	{
		return Db::getInstance()->execute('CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'clariprint_solver_cache`(
			`id_cache` varchar(32) NOT NULL,
			`created` datetime NOT NULL,
			`value` LONGBLOB,
			PRIMARY KEY (`id_cache`)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8');
	}

	public static function dropTables()
	{
		return Db::getInstance()->execute('DROP TABLE `'._DB_PREFIX_.'clariprint_solver_cache`');
	}
	
	static function cleanCache() {
		return Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.'clariprint_solver_cache`');
	}

	static function refreshCache() {
		return Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.'clariprint_solver_cache` WHERE  DATEDIFF(NOW(),created) > 20');
	}

	static function checkCache($product) {
		if ($v = Db::getInstance()->getValue('SELECT value FROM `'._DB_PREFIX_.'clariprint_solver_cache` WHERE  id_cache=\''. md5($product) .'\''))
			return json_decode($v);
		return null;
	}
	static function addToCache($product,$result) {
		$db = Db::getInstance();
		if (is_object($result)) $result = json_encode($result);
		if (is_array($result)) $result = json_encode($result);
			
		$db->execute(sprintf('INSERT INTO `'._DB_PREFIX_.'clariprint_solver_cache` (id_cache,created,value) VALUES (\'%s\',NOW(),\'%s\')',
										md5($product),$db->escape($result)));
		return $result;
	}
	
	
	public function callClariprint($product,$use_cache=true)
	{
		if ($use_cache) {
			if ($x = self::checkCache($product)) {
				return $x;
			}
		}
		$v = ClariprintConnect::quoteRequesQuery($product);
		if ($use_cache) {
			if ($v) {
				if ($v->success && $v->response > 0) {
					self::addToCache($product,$v);
				}
			}
		}
		return $v;
	}
}
