

var Clariprint = {};
var CLDBG = null;
Clariprint.parseFloat = function(txt)
{
	var x = parseFloat(txt.replace(',','.'));
	if (isNaN(x)) return 0.0;
	return x;
}




Clariprint.setFolding = function(fold)
{
	var width = Clariprint.parseFloat($(fold).parents('.clariprint_element').find('.ClWidth').val());
	var height = Clariprint.parseFloat($(fold).parents('.clariprint_element').find('.ClHeight').val());
	var hf = Clariprint.parseFloat($(fold).attr('foldheight'));
	var hw = Clariprint.parseFloat($(fold).attr('foldwidth'));
	$(fold).parents('.clariprint_element').find('.ClOpenHeight').val(hf*height);
	$(fold).parents('.clariprint_element').find('.ClOpenWidth').val(hw*width);
}

jQuery.widget("clariprint.clint",{
	max : '',
	min : '',
	_create: function() {
		this.element.on('blur',jQuery.proxy(this.keyup,this));
		this.max = parseInt(this.element.attr('cl_max'));
		this.min = parseInt(this.element.attr('cl_min'));
	},
	keyup: function(evt){
		var v = parseInt(this.element.val());
		if (this.max != '') {
			if (v > this.max) v = this.max;
		}
		if (this.min != '') {
			if (v < this.min) v = this.min;
		}
		if (isNaN(v)) this.element.addClass("CLWarning");
		else this.element.removeClass("CLWarning");

		this.element.val(v);
	}
});

jQuery.widget("clariprint.clfloat",{
	max : '',
	min : '',

	_create: function() {
		this.element.on('blur',jQuery.proxy(this.keyup,this));
		this.max = parseFloat(this.element.attr('cl_max'));
		this.min = parseFloat(this.element.attr('cl_min'));
	},
	keyup: function(evt){
		var v = parseFloat(this.element.val().replace(',','.').replace(/[^0-9.]+/g,''));
		if (this.max != '') {
			if (v > this.max) v = this.max;
		}
		if (this.min != '') {
			if (v < this.min) v = this.min;
		}
		if (isNaN(v)) this.element.addClass("CLWarning");
		else this.element.removeClass("CLWarning");
		this.element.val(v);
	}
});


jQuery.widget( "clariprint.paper", {
	quality:null,
	brand:null,
	color:null,
	weight:null,
	process:null,
	_create: function() {
		this.quality = $(this.element).find('select.quality').first();
		this.brand = $(this.element).find('select.brand').first();
		this.color = $(this.element).find('select.color').first();
		this.weight = $(this.element).find('select.weight').first();
		
		if (this.quality.lentgh > 0) $(this.quality).bind('change',jQuery.proxy(this.onChange,this));
		else this.quality = $(this.element).find('input.quality').first();

		if (this.brand.lentgh > 0) $(this.brand).bind('change',jQuery.proxy(this.onChange,this));
		else this.brand = $(this.element).find('input.brand').first();

		if (this.color.lentgh > 0) $(this.color).bind('change',jQuery.proxy(this.onChange,this));
		else this.color = $(this.element).find('input.color').first();

		if (this.weight.lentgh > 0) $(this.weight).bind('change',jQuery.proxy(this.onChange,this));
		else this.weight = $(this.element).find('input.weight').first();
		this.onChange();
		CLDBG = this;
	},

	populateSelect: function(select,options,empty) {
		
		var current = select.attr('value');
		var html = '';
		if (empty) html = '<option value="">-</option>';
		for(var i =0; i < options.length; i++) {
			html += '<option value="' + options[i] + '"';
			if (options[i] == current) html += ' selected'; 
			html += '>' + options[i] + '</option>';
		}
		select.html(html);
		
	
	},
	ajaxDone: function(data, textStatus, jqXHR) {
		if (this.quality.is('SELECT'))
			this.populateSelect(this.quality,data.qualities,false);
		if (this.brand.is('SELECT'))
			this.populateSelect(this.brand,data.brands,true);
		if (this.color.is('SELECT'))
			this.populateSelect(this.color,data.colors,true);
		if (this.weight.is('SELECT'))
			this.populateSelect(this.weight,data.weights,false);
	},
	
	onChange: function(evt) {
		jQuery.ajax('/index.php',{
				'data' : {
					'fc': 'module',
					'module' : 'clariprint',
					'controller' : 'paper',
					'ajax' : 1,
					'action' : 'paperselector',
					'process' : this.element.attr('clariprint_paper_process'),
					'quality' : this.quality.attr('value'),
					'brand' : this.brand.attr('value'),
					'color' : this.color.attr('value'),
					'weight' : this.weight.attr('value')
					},
				'dataType' : 'json'})
			    .done(jQuery.proxy(this.ajaxDone,this))
			    .fail(function() {
			      alert( "error" );
			    });
		
	},
	onSuccess: function(resp) {
	}
});

jQuery.widget("clariprint.adminsolver", {
	_create: function(options) {
		$('#ClariprintAdminGetPrice').on('click',jQuery.proxy(this.getPrice,this));
	},

	getPrice: function(product)
	{
		var product = $('#product_form').serialize();
		$('#clariprint_solver_message').html("Calcul du prix ..");
		jQuery.ajax('/index.php',{
				'type': 'POST',
				'data' : {
					'fc': 'module',
					'module' : 'clariprint',
					'controller' : 'solver',
					'nodiscount' :1,
					'no_cache': 1,
					'ajax' : 1,
					'action' : 'PriceRequest',
					'content' : 'urlencoded',
					'product' : product
				},
				'dataType' : 'json',
				'error' : function( jqXHR,  textStatus,  errorThrown ) {
					alert( "Price request error "  + textStatus + " (" + errorThrown + ")");
				},
				'success':jQuery.proxy(this.getPriceDone,this)
			});
	},
	getPriceDone: function(data, textStatus, jqXHR) {
		if (data && data.success && data.response > 0 ) {
			console.log(data);
			$('#clariprint_resume').html(data.html);
			$('#details_produit').show();
			$('#priceTE').val(data.response);
			$('#priceTE').keyup();
			$('#clariprint_solver_message').html("prix mis à jour : " + data.priceHT + ". N'oubliez pas d'enregistrer");
		} else {
			$('#clariprint_solver_message').html("Error");
		}
	}
});



jQuery.widget("clariprint.solver", {
	lastresponse:null,
	interval:null,
	hash:null,
	defaults:{'live': true, 'button': null},
	options:null,
	_create: function(options) {
		this.options = $.extend( {}, this.defaults, options);

		if (this.options.live)
			this.interval  = setInterval(jQuery.proxy(this.checkForm,this),500);
		if (this.options.button)
			$(this.options.button).on('click',jQuery.proxy(this.adminPrice,this));
		$('#add_to_cart input').unbind('click').click(
			jQuery.proxy(this.addToCart,this));
		$('p#add_to_cart').hide();
	},
	
	dialog:null,
	initAddToCart: true,
	
	addToCart: function() {
		if (this.initAddToCart) {
			jQuery('#clariprint_cart_cancel').button();
			jQuery('#clariprint_cart_cancel').on('click',$.proxy(this.cancelAddToCart,this));

			jQuery('#clariprint_cart_add').button();
			jQuery('#clariprint_cart_add').on('click',$.proxy(this.submitAddToCart,this));
			this.initAddToCart = false;
		}
		$('#clariprint_product_key').val(this.element.serialize());

		this.dialog = $('#clariprint_cart').dialog({modal: true,'width': 450 });
		return false;
	},

	cancelAddToCart: function() {
		$("#clariprint_cart").dialog('close');
		return false;
	},
	
	submitAddToCart: function(evt) {
//		jQuery('cl_reload').val(window.location.pathname + window.location.search);
	},
	
	submitAddToCartDone: function()
	{
		$("#clariprint_cart").dialog('close');
		alert("ok");
	},
	
	updateProductPrice: function(data, textStatus, jqXHR) {
		console.log(jqXHR);
	},
	
	checkForm: function() {
		var ser = this.element.serialize();
		if (ser != this.hash)
		{
			this.getPrice(this.element.serialize());
		}	
		this.hash = ser;
	},
	
	getPrice: function(product)
	{
		$('p#add_to_cart').hide();
		
		$('#our_price_display').html("Calcul de votre prix ..");
		jQuery.ajax('/index.php',{
				'type': 'POST',
				'data' : {
					'fc': 'module',
					'module' : 'clariprint',
					'controller' : 'solver',
					'ajax' : 1,
					'action' : 'PriceRequest',
					'content' : 'urlencoded',
					'product' : product
				},
				'dataType' : 'json',
				'error' : function( jqXHR,  textStatus,  errorThrown ) {
					$('p#add_to_cart').hide();
					alert( "Price request error "  + textStatus + " (" + errorThrown + ")");
				},
				'success':jQuery.proxy(this.getPriceDone,this)
			});
	},
	getPriceDone: function(data, textStatus, jqXHR) {
		if (data && data.success && data.response > 0 ) {
			this.lastresponse  = data;
			$('#short_description_content').html(data.html);
			$('#our_price_display').html(data.responseTxt);
			$('p#add_to_cart').show();
		} else {
			
			$('#our_price_display').html("Essayez une autre configuration ou contactez nous");
			$('p#add_to_cart').hide();
		}
	}
});


Clariprint.updateQuantity = function(v) {$('#clariprint_quantity').val(v); };


jQuery.widget("clariprint.clariprint_colors",{
	cyan:null,
	magenta:null,
	yellow:null,
	black:null,
	four:null,
	_create: function() {
		this.cyan = $(this.element).find('input[value=cyan]');
		this.magenta = $(this.element).find('input[value=magenta]');
		this.yellow = $(this.element).find('input[value=yellow]');
		this.black = $(this.element).find('input[value=black]');
		this.four = $(this.element).find('input[value=4-color]');
		if (this.cyan) 		$(this.cyan).on('click',$.proxy(this.checkVals,this));
		if (this.magenta) 	$(this.magenta).on('click',$.proxy(this.checkVals,this));
		if (this.yellow)		$(this.yellow).on('click',$.proxy(this.checkVals,this));
		if (this.black)		$(this.black).on('click',$.proxy(this.checkVals,this));
		if (this.four)		$(this.four).on('click',$.proxy(this.checkFour,this));
	},
	checkVals: function(evt) {
		this.four.prop('checked',(this.cyan.prop('checked') && 
			 this.magenta.prop('checked') && 
			 this.yellow.prop('checked') && 
			 this.black.prop('checked')));
	},
	checkFour: function(evt) {
		var x = this.four.prop('checked');
		this.cyan.prop('checked',x);
		this.magenta.prop('checked',x);
		this.yellow.prop('checked',x);
		this.black.prop('checked',x);
	}
});

jQuery(function($){
	$("input.CLInt").clint();
	$("input.CLFloat").clfloat();
	$(".PaperWidget").paper();
	$("form.ClariprintSolverWidget").solver();
	$(".folding_tabs").tabs();
	$(".ClariprintColorWidget").clariprint_colors();

	$('.NoSubmit').keydown(Clariprint.noSubmit);
	if (typeof(tinySetup) !== 'undefined')
		tinySetup({editor_selector :"clariprint_rte"});
});




Clariprint.noSubmit = function(evt) {
	if (evt.which == 13) { event.preventDefault(); $(event.target).change(); }
}
