<?php
/*
* 2012 expert-solutions
*
*  @author Expert Solutions SARL <contact@expert-solutions.fr>
*  @copyright  2012 Expert Solutions SARL
*  @version  Release: $Revision: 14011 $
*  @license	Proprietary EXPERT SOLUTIONS SARL
*/
if (!defined('_PS_VERSION_'))
	exit;


require_once(dirname(__FILE__) . '/classes/clariprint_config.php');
require_once(dirname(__FILE__) . '/classes/clariprint_customer.php');
require_once(dirname(__FILE__) . '/classes/clariprint_paper.php');
require_once(dirname(__FILE__) . '/classes/clariprintmargin.php');
require_once(dirname(__FILE__) . '/classes/clariprintconnect.php');
require_once(dirname(__FILE__) . '/classes/clariprintcategory.php');

require_once(dirname(__FILE__) . '/controllers/front/solver.php');

// require_once(dirname(__FILE__) . '/controllers/front/cart.php');

function in_array_silent($val,$array)
{
	if (!$array) return false;
	if (!$val) return false;
	return in_array($val,$array);
}

class Clariprint extends Module
{
	private $hooks;
	
	var $paper_kinds;
	var $current_config = null;
	
	public function setupDatabase()
	{
		ClariprintPaper::createTable();
		ClariprintMargin::createTable();
		ClariprintSolverModuleFrontController::createTables();
		ClariprintCategory::install();
		
		if (!$this->checkDatabase())
		{	Db::getInstance()->execute('CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'clariprint_product` (
			id int AUTO_INCREMENT PRIMARY KEY,
			product_id int(11),
			product_kind varchar(30),
			product_json longblob,
			product_xml longblob)');
//			CONSTRAINT FOREIGN KEY (product_id) REFERENCES `'._DB_PREFIX_.'product` (product_id))' );
		}
		
		Clariprint_Customer::createTable();
	}
	
	public function checkDatabase()
	{
		$res = Db::getInstance()->executeS('SHOW TABLES LIKE \''._DB_PREFIX_.'clariprint_product\'');
		return (count($res) == 1);
	}


	public function __construct()
	{
		$this->name = 'clariprint';
		$this->tab = 'market_place';
		$this->version = 2;
		$this->author = 'EXPERT SOLUTIONS SARL';
		$this->need_instance = 0;
		$this->configs = array('CL_DEFAULT_HOST','CL_DEFAULT_LOGIN','CL_DEFAULT_PASSWORD','CL_DEFAULT_CSS','CL_DB_VERSIONS');
		parent::__construct();
		$this->displayName = $this->l('Clariprint');
		$this->description = $this->l('Clariprint et PrestaShop.');
		$this->_errors = array();
		
		$this->hooks = array(
			/* front */
			'displayHeader',
			
			"displayProductButtons", //Put new action buttons on product page
			"displayFooterProduct", // Add new blocks under the product description
			"actionProductUpdate",

			"actionOrderStatusPostUpdate",
			
			/* admin */
			'displayBackOfficeHeader', // permet d'ajouter les js et css
			"displayAdminCustomers", // admin
			"displayAdminProductsExtra"
		);
		
	}

	static public function getConfig($product_id) {
		
		return (bool)Db::getInstance()->getRow('SELECT * FROM `'._DB_PREFIX_.'clariprint_product` WHERE `id_product` = '.(int)$product_id);
		
	}
	
	
	private function checkHooks()
	{
		// Retrieve hooks used by the module
		$registered  = array();
		$sql = 'SELECT `id_hook` FROM `'._DB_PREFIX_.'hook_module` WHERE `id_module` = '.(int)$this->id;

		$result = Db::getInstance()->executeS($sql);
		foreach	($result as $row)
		{
			$hook = new Hook($row['id_hook']);
			$registered[] = $hook->name;
		}
		// remove unknwon 
		foreach($registered as $r) {
			if (!in_array($r,$this->hooks)) {
				$this->_confirmations[] = "remove hooks $r<br>";
				$this->unregisterHook($r);
			}
		}
		// add new hooks
		foreach($this->hooks as $h) {
			if (!in_array($h,$registered)) {
				$this->_confirmations[] = "add hooks $h<br>";
				$this->registerHook($h);}
		}
		
	}
	
	
	

	public function enable($forceAll = false)
	{
		if (!parent::enable()) return false;
		$this->setupDatabase();
		$this->checkHooks();
/*		foreach($this->hooks as $hook)
		{	
			if (!$this->registerHook($hook)) return false;
		}
*/
		
		$this->installTabs();
		return true;
	}

	public function disable($forceAll = false)
	{
//		foreach($this->hooks as $hook)
//		{	$this->unregisterHook($hook); }
		$this->uninstallTabs();
		return parent::disable();
	}

	private function installTabs()
	{
		$idTabParent = 0;
		$idTabParent = (int)Tab::getIdFromClassName('AdminCatalog');
		$this->installModuleTab('AdminClariprintPapers',  'Papers',$idTabParent);
		$this->installModuleTab('AdminClariprintProducts',  'Clariprint Products',$idTabParent);
		$this->installModuleTab('AdminClariprintMargins',  'Clariprint Margins',$idTabParent);


	}

	private function uninstallTabs()
	{
		$this->uninstallModuleTab('AdminClariprintPapers');
		$this->uninstallModuleTab('AdminClariprintProducts');
		$this->uninstallModuleTab('AdminClariprintMargins');
	}

	private function installModuleTab($tabClass, $tabName, $idTabParent)
	{
		$tab = new Tab();
		$tab->name = array(1 =>$tabName );
		foreach (Language::getLanguages(false) as $lang)
			$tab->name[(int)$lang['id_lang']] = $tabName;
		$tab->class_name = $tabClass;
		$tab->module = $this->name;
		$tab->id_parent = $idTabParent;

		if(!$tab->save())
			return false;
		return true;
	}
	private function uninstallModuleTab($tabClass)
	{
		$idTab = Tab::getIdFromClassName($tabClass);
		if($idTab != 0)
		{
			$tab = new Tab($idTab);
			$tab->delete();
			return true;
		}
		return false;
	}

	public function setMedia()
	{
		d("setMedia");
	}
	public function hookDisplayLeftColumnProduct($params)
	{
		return null;

	}

//	displayRightColumnProduct
//	hookproductOutOfStock

	public function hookDisplayProductButtons($param)
	{
		$html = '';
		if ($config = $this->clariprintConfig($param['product']->id))
		{
			$prod = json_decode($config->product_json);
			if ($prod->options->quantity == 'list') {
				$html .= '<fieldset class="attribute_fieldset product_attributes clariprint"><label class="attribute_label" for="clariprint_quantite">'. $this->l('Quantity:') . '&nbsp;</label>';
				$qts = explode("\n",$prod->options->quantities);
				$html .=  '<select name="clariprint_quantity2" id="clariprint_quantity2" class="" onchange="Clariprint.updateQuantity(this.value);" style=" height: 28px; font-size: 13.63636302947998px;">';				
				foreach($qts as $qt) {
					$sel ='';
					if ($prod->quantity == $qt) $sel = ' selected';
					$html .= sprintf('<option%s>%d</option>',$sel,$qt);
				}
				$html .= '</select></fieldset>';
			} elseif ($prod->options->quantity == 'free') {
					$html .= '<fieldset class="attribute_fieldset product_attributes clariprint"><label class="attribute_label" for="clariprint_quantite">'. $this->l('Quantity:') . '&nbsp;</label><br/>';
					$html .=  sprintf('<input type="number" name="clariprint_quantity2" id="clariprint_quantity2" class="CLInt numeric NoSubmit" onchange="Clariprint.updateQuantity(this.value);" style="  height: 28px; font-size: 13.63636302947998px;" value="%d" step="%d" cl_max="%d" cl_min="%d"/>',
						$prod->quantity,$product->quantity / 10,$product->options->quantity_to,$product->options->quantity_from);
					if ($prod->options->quantities) {
						$html .=  '<select name="clariprint_quantity3" onchange="$(\'#clariprint_quantity2\').val(this.value); Clariprint.updateQuantity(this.value);">';
						$qts = explode("\n",$prod->options->quantities);
						foreach($qts as $qt) {
							$sel ='';
							if ($prod->quantity == $qt) $sel = ' selected';
							$html .= sprintf('<option%s>%d</option>',$sel,$qt);
						}
						$html .= '</select>';
					}
					$html .= '</fieldset>';
					
			} else if ($prod->options->quantity == 'range') {
				$html .= '<fieldset class="attribute_fieldset product_attributes clariprint"><label class="attribute_label" for="clariprint_quantite">'. $this->l('Quantity:') . '&nbsp;</label>';
				$qts = explode("\n",$prod->options->quantities);
				$html .=  '<select name="clariprint_quantity2" id="clariprint_quantity2" class="" onchange="Clariprint.updateQuantity(this.value);" style=" height: 28px; font-size: 13.63636302947998px;">';
				
				$minstep = ($prod->options->quantity_to - $prod->options->quantity_from) / 20;
				$minstep = (floor($minstep / 10) * 10);
				$minstep = max($minstep,1);
				$step = max($minstep,$product->options->quantity_step);
				$i=$prod->options->quantity_from;
				for(; $i <= $prod->options->quantity_to; ) {
					$sel ='';
					if ($prod->quantity == $i) $sel = ' selected';
					$html .= sprintf('<option%s>%d</option>',$sel,$i);
					$i +=  $step;
				}
				$html .= '</select></fieldset>';
			} 
		}	
		return $html;
	}

	public function hookDisplayBackOfficeHeader($param)
	{
		$this->context->controller->addCSS(($this->_path).'clariprint.css', 'all');
		$this->context->controller->addJquery();
		$this->context->controller->addJqueryUi('ui.widget');
		$this->context->controller->addJqueryUi('ui.button');
		$this->context->controller->addJqueryUi('ui.tabs');
	}
	
	public function hookDisplayHeader($param)
	{
		$this->context->controller->addCSS(($this->_path).'clariprint.css', 'all');
		$this->context->controller->addJqueryUi(array('ui.widget','ui.button','ui.tabs','ui.accordion','ui.dialog'));
		$this->context->controller->addJS(($this->_path).'js/clariprint.js', 'all');
		
	}	
	
	
	public function clariprintConfig($id_product) {
		if (!$this->current_config) 
			$this->current_config = Clariprint_Config::objectForProduct($id_product);
		return $this->current_config;
	}
	
	public function hookDisplayProductTab($param) {
		if ($config = $this->clariprintConfig($param['product']->id))
		{
			return '<li><a id="clariprint_product_tab" href="#clariprint_product_tab_content">'. $this->l("Clariprint") .'</a></li>';
		}
		return null;
	}
	
	public function config($product_id) {
//		echo ("productid :"  . $product_id);
		
		
		return false;
	}
	
	private function _displayForm()
	{
		//					<input type="text" name="voucher" value="'.Configuration::get('NW_VOUCHER_CODE').'" />

		$this->_html .= '<form method="post" action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'">
			<fieldset>
				<legend><img src="'.$this->_path.'logo.png" />'.$this->l('Settings').'</legend>';
		foreach ($this->_errors AS $err) $this->_html .= '<div class="error">'.$err.'</div>';
		foreach ($this->_confirmations AS $info) {if ($info) $this->_html .= '<div class="info">'.$info.'</div>';}
		
				
				
				
/*		$cat_id = null;
		if ($cat = ClariprintCategory::getDefaultCategory()) $cat_id = $cat->id;*/
		

		$this->_html .= '<label>'.$this->l('Clariprint serveur base URL').'</label>
				<div class="margin-form">
					<input type="text" size="50" name="cl_server_url" value="'.  Configuration::get('CL_SERVER_URL') . '" id="cl_server_url">
				</div>';
			
		$this->_html .= '<label for="cl_server_url">'.$this->l('login').'</label>
				<div class="margin-form">
					<input type="text" name="cl_server_login" value="'.  Configuration::get('CL_SERVER_LOGIN') . '" id="cl_server_url">
				</div>';
		$this->_html .= '<label>'.$this->l('password').'</label>
				<div class="margin-form">
					<input type="text" name="cl_server_password" value="'.  Configuration::get('CL_SERVER_PASSWORD') . '" id="cl_server_url">
				</div>';


		$this->_html .= '<label>'.$this->l('category').'</label>
						<div class="margin-form">
							<input type="text" name="cl_category_template" value="'.  Configuration::get('CL_CATEGORY_TEMPLATE') . '" id="cl_category_template">
						</div>';


		$this->_html .= '<label>'.$this->l('delivery').'</label>
						<div class="margin-form">
							<select name="cl_delivery" multiple>';
		$countries = array('fra');
		$mycountries = explode(',',  Configuration::get('CL_DELIVERY'));
		foreach($countries  as $c) {
			if (in_array($c,$mycountries))
				 $this->_html .= '<option selected>'.$c.'</option>';
			else $this->_html .= '<option>'.$c.'</option>';
		}
		$this->_html .= '</select>
						</div>';


		if ($this->checkauth > 0)
			$this->_html .= $this->l("login successful");
		elseif ($this->checkauth < 0)
			$this->_html .= $this->l("login failed.");
			
		$this->_html .= '
				<div class="margin-form clear pspace"><input type="submit" name="submitUpdate" value="'.$this->l('Update').'" class="button" /></div>
				<div class="margin-form clear pspace"><input type="submit" name="svnUpdate" value="'.$this->l('Update Module').'" class="button" /></div>
				<div class="margin-form clear pspace"><input type="submit" name="ClariprintCleanCache" value="'.$this->l('Clean cache').'" class="button" /></div>
			</fieldset>
		</form>';

		return $this->_html;
	}
	var $checkauth = 0;
	
	public function getDeliveriesOptions() {
		$countries = Configuration::get('CL_DELIVERY');
		if (!$countries) $countries  = 'fra';
		$mycountries = explode(',', $countries );
		$res = array();
		$geodir = _PS_MODULE_DIR_.'clariprint/geo/';
		
		foreach($mycountries as $c) {
			$fname= $geodir .  $c.  '.json';
			if (is_file($fname))
			{
				$fx = file_get_contents($fname);
				$x = json_decode($fx);
				$res[] = $x;
			}	
		}
		return $res;
	}
	
	
	public function getContent() {
		foreach ($this->_errors AS $err) $this->_html .= '<div class="errmsg">'.$err.'</div>';
		
		if (Tools::isSubmit('submitUpdate'))
		{
			Configuration::updateValue('CL_SERVER_URL', pSQL($_POST['cl_server_url']));
			Configuration::updateValue('CL_SERVER_LOGIN', pSQL($_POST['cl_server_login']));
			Configuration::updateValue('CL_SERVER_PASSWORD', pSQL($_POST['cl_server_password']));
			Configuration::updateValue('CL_CATEGORY_TEMPLATE', pSQL($_POST['cl_category_template']));

			Configuration::updateValue('CL_DELIVERY', pSQL(implode(',',$_POST['cl_delivery'])));
			
			$this->checkauth =(ClariprintConnect::checkAuth() ? 1 : -1); 
		}
		if (Tools::isSubmit('svnUpdate'))
		{
			$output = array();
			$svn = 'svn --non-interactive --username presta  --password P5wvRBazIBqv update ' . _PS_MODULE_DIR_ .'/clariprint 2>&1';
			
			$res = exec($svn,$output);
			$this->_confirmations[] = implode('<br>',$output);
			$this->runUpdates();
			$this->checkHooks();
		}
		if (Tools::isSubmit('ClariprintCleanCache'))
		{
			Db::getInstance()->execute('DELETE FROM `'._DB_PREFIX_.'clariprint_solver_cache`');
			$this->_confirmations[] = "Clean cache";
		}
		
		return $this->_displayForm();
	}
	
	

	public function finishingMatchInlineFull($f) {
		return ($f['index'] <= 19);
	}
	public function finishinghInlineFull() {
		return array_filter($this->finishingOptions(), array($this,"finishingMatchInlineFull"));
	}

	public function finishingMatchInlineSoft($f) {
		return ($f['index'] <= 12);
	}

	public function finishingInlineSoft() {
		return array_filter($this->finishingOptions(), array($this,"finishingMatchInlineSoft"));
	}

	public function finishingMatchOfflineFull($f) {
		return ($f['index'] >= 20 && $f['index'] <=  35);
	}
	public function finishingOfflineFull() {
		return array_filter($this->finishingOptions(), array($this,'finishingMatchOfflineFull'));
	}


	public function finishingMatchOfflineSoft($f) {
		switch($f['index']) {
			case 19:
			case 21:
			case 22:
			case 24:
			case 31;
			case 33:
			return true;
		}
		return false;
	}
	public function finishingOfflineSoft($f) {
		return array_filter($this->finishingOptions(), array($this,'finishingOfflineSoft'));
	}
	
	static public function finishingTxt($v)
	{
		return self::finishingKindTxt($v) . self::finishingFinitionTxt($v) . self::finishingSelectifTxt($v);
	}
	
	static function finishingKindTxt($v) {
		return 'vernis';
	}
	
	static function finishingFinitionTxt($v) {
		switch($v['finition']) {
			case 'BRILLANT': return ' brillant';
			case 'MAT': return ' mat';
			case 'SATIN': return ' satin';
		}
		return '';
	}
	/*
	static function finishingSelectifTxt($v) {
		if (isset($v['reserve'])) {
			$r = $v['reserve'];
			if (self % UvNumerique & self.reserve = 10) " sélectif < 10%"
				else if (self % UvNumerique & self.reserve = 30) " sélectif < 30%"
				else if (self % UvNumerique & self.reserve = 50) " sélectif > 30%"
				else if (self.reserve % (1 .. 49)) " with space for stamp" 
				else if (self.reserve = 50)	" réservé"
				else if (self.reserve > 50)	" sélectif 30%"
				else "") /+
			(	if (not(self.roto?) & infoAdd) " (hors roto)" 
				else ""	)]



			if ($r < 10) return ($v['kind'] == 'UvNumerique' ? 'sélectif < 10%' )
			if ($r < 50) return ($v['kind'] == 'UvNumerique' ? 'sélectif < 10%' )
			switch($v['finition') {
				case 'BRILLANT': return " brillant";
				case 'MAT': return " mat";
				case 'SATIN': return " satin";
			}
			
		} else return '';
	}
	
	*/


	public  function infoFinishingSmarty($params, &$smarty)
	{
		if (isset($params['txt'])) return $this->infoFinishing($params['txt']);
		return "?";
	}	
	public function infoFinishing($txt)
	{
		if ($txt == '') return $this->l('None');
		$vs = explode("+",$txt);
		$res = array();
		$l = self::finishingOptions();
		foreach($vs as $v)
		{
			if (isset($l[$v])) {
				$vo = $l[$v];
/*				if ($this)
					$res[] = $this->l($vo['info']);
				else */
				$res[] = $vo['info'];
			}
		}
		return implode(' + ',$res);
	}
	
	
	static public function setupFolds($params, &$smarty)
	{
		$mod = self::getInstanceByName('clariprint');
		$product = $params['product'];
		$res = array();
		$pages = $mod->getFolds();
		foreach($pages as $page => $folds)
		{
			$p = array();
			foreach($folds as $f)
			{
				if (in_array_silent($f['index'],$product->options->folds)) {
					$p[] = $f;
				}
			}
			if (count($p) > 0) $res[$page] = $p;
		}
		$smarty->assign(array('productfolds' => $res));
		return null;
	}
	
	
	public function getFolderDie() {
		return array(array('index' => 1, 'title' => $this->l('folder with 1 flap without leg of joining')),
					array('index' => 2, 'title' => $this->l('folder with 1 flap without leg of joining')),
					array('index' => 3, 'title' => $this->l('folder with 1 flap and a glue flap')),
					array('index' => 4, 'title' => $this->l('folder with 1 flap and a glue flap')),
					array('index' => 5, 'title' => $this->l('folder with 2 flaps without locking flap')),
					array('index' => 6, 'title' => $this->l('folder with 2 flaps without locking flap')),
					array('index' => 7, 'title' => $this->l('folder with 2 flaps and a locking flap')),
					array('index' => 8, 'title' => $this->l('folder with 2 flaps and a locking flap')),
					array('index' => 9, 'title' => $this->l('folder with 2 flaps + visit cards slotting + locking flap')),
					array('index' => 10, 'title' => $this->l('folder with 2 flaps + visit cards slotting + locking flap')),
					array('index' => 11, 'title' => $this->l('folder with 2 flaps + visit cards slotting + locking flap')),
					array('index' => 12, 'title' => $this->l('folder with 2 flaps + visit cards slotting + locking flap')),
					array('index' => 13, 'title' => $this->l('folder with 2 flaps in window and a locking flap')),
					array('index' => 14, 'title' => $this->l('folder with 2 flaps in window and a locking flap')),
					array('index' => 15, 'title' => $this->l('folder with 3 flaps without locking flap')),
					array('index' => 16, 'title' => $this->l('folder with 3 flaps without locking flap')),
					array('index' => 17, 'title' => $this->l('folder with 3 flaps and a locking flap')),
					array('index' => 18, 'title' => $this->l('folder with 3 flaps and a locking flap')),
					array('index' => 19, 'title' => $this->l('folder with 4 flaps without locking flap')),
					array('index' => 20, 'title' => $this->l('folder with 5 flaps without locking flap')),
					array('index' => 21, 'title' => $this->l('folder with 4 flaps and a locking flap')),
					array('index' => 22, 'title' => $this->l('folder with 5 flaps and a locking flap')));
	}
	
	public function getFolds() {
		return 	array(
	'4' => array(	array('index' => 1,  'title' => $this->l('simple fold'), 'height' => 1, 'width' => 2)),
	'6' => array(	array('index' => 2,  'title' => $this->l('2 fan folds'), 'height' => 1, 'width' => 3),
					array('index' => 3,  'title' => $this->l('2 rolled folds'), 'height' => 1, 'width' => 3),
					array('index' => 39, 'title' => $this->l('window folds'), 'height' => 1, 'width' => 4)),
	'8' => array(	array('index' => 4,  'title' => $this->l('2 parallel folds'), 'height' => 1, 'width' => 4),
					array('index' => 5,  'title' => $this->l('3 rolled folds'), 'height' => 1, 'width' => 4),
					array('index' => 6,  'title' => $this->l('3 fan folds'), 'height' => 1, 'width' => 4),
					array('index' => 10, 'title' => $this->l('2 crossed folds'), 'height' => 2, 'width' => 2),
					array('index' => 40, 'title' => $this->l('3 gate folds'), 'height' => 1, 'width' => 4)),
	'10' => array(	array('index' => 7,  'title' => $this->l('4 fan folds'), 'height' => 1, 'width' => 5)),

	'12' => array(	array('index' => 8,  'title' => $this->l('1 fold + 2 fan folds'), 'height' => 1, 'width' => 6),
					array('index' => 11, 'title' => $this->l('5 fan folds'), 'height' => 1, 'width' => 6),
					array('index' => 12, 'title' => $this->l('2 rolled folds + 1 crossed fold'), 'height' => 2, 'width' => 3),
					array('index' => 13, 'title' => $this->l('2 fan folds + 1 cross fold'), 'height' => 2, 'width' => 3),
					array('index' => 14, 'title' => $this->l('1 fold + roll folds'), 'height' => 1, 'width' => 6),
					array('index' => 15, 'title' => $this->l('1 fold + 2 fan folds'), 'height' => 3, 'width' => 2),
					array('index' => 16, 'title' => $this->l('2 rolled folds + 1 crossed fold'), 'height' => 2, 'width' => 3)),

	'14' => array(	array('index' => 17, 'title' => $this->l('6 fan folds'), 'height' => 1, 'width' => 7)),
	'16' => array(	array('index' => 9,  'title' => $this->l('1 fold + 2 parallel folds'), 'height' => 1, 'width' => 8),
					array('index' => 18, 'title' => $this->l('7 fan folds'), 'height' => 1, 'width' => 8),
					array('index' => 19, 'title' => $this->l('2 parallel folds + 1 crossed fold'), 'height' => 2, 'width' => 4),
					array('index' => 32, 'title' => $this->l('3 crossed folds'), 'height' => 2, 'width' => 4),
					array('index' => 33, 'title' => $this->l('2 parallel folds + 1 crossed fold'), 'height' => 2, 'width' => 4)),
	'24' => array(	array('index' => 26, 'title' => $this->l('2 parallel folds + 2 rolled folds'), 'height' => 3, 'width' => 4),
					array('index' => 27, 'title' => $this->l('2 parallel folds + 2 fan folds'), 'height' => 3, 'width' => 4),
					array('index' => 28, 'title' => $this->l('2 fan folds + 2 parallel folds'), 'height' => 4, 'width' => 3),
					array('index' => 29, 'title' => $this->l('2 rolled folds + 2 parallel folds'), 'height' => 4, 'width' => 3)),
	'32' => array(	array('index' => 30, 'title' => $this->l('2 parallel folds + 2 parallel folds'), 'height' => 4, 'width' => 4),
					array('index' => 35, 'title' => $this->l('1 fold + 2 parallel folds + 1 cross fold'), 'height' => 4, 'width' => 4)));
	}
	
	public function wrapping() {
		return array(
		'shrink' => $this->l('Shrink-wrapped packing'),
		'cardboard' => $this->l('cardboard wrap'),
		'cardboardbox' => $this->l('cardboard box'),
		'lostpallet' => $this->l('lost pallet packing'),
		'boxpallet' => $this->l('box pallet packing'),
		'eupallet' => $this->l('european pallet packing'),
		'elasticband' => $this->l('elastic band packing'),
		'kraft' => $this->l('under kraft paper'),
		'crosslink' => $this->l('Cross link packing'));
	}
	
	static function getPapers() {
		return array('of'=> array('qualities' => ClariprintPaper::qualities(null,'of'),
								"brands" => ClariprintPaper::brands(null,'of'),
								"colors" => ClariprintPaper::colors(null,'of'),
								"weights" => ClariprintPaper::weights(null,'of')),
					'of'=> array('qualities' => ClariprintPaper::qualities(null,'or'),
								"brands" => ClariprintPaper::brands(null,'or'),
								"colors" => ClariprintPaper::colors(null,'or'),
								"weights" => ClariprintPaper::weights(null,'or')));
	}
	
	
	static function paperKinds() {
		return array("of" => "Offset feuille"
/*					"or" => "Offset roto",
					"oc"  => "Offset roto coldset", 
					"n" => "Numérique",
					"h" => "hélio",
					"f" => "Flexographie",
					"s" => "Sérigraphie" */ );
		
	}
	
	static function setupfinishingOptions($params,&$smarty) {
		$mod = self::getInstanceByName('clariprint');
		$product = $params['product'];
		$options = $mod->finishingOptions();
		$front_inline_varnish = array();
		$back_inline_varnish = array();

		$front_all = in_array_silent('all',$product->options->finishing_front);
		$back_all = in_array_silent('all',$product->options->finishing_front);
		foreach($mod->finishinghInlineFull() as $kvel => $vel)
		{
			if ($front_all || in_array_silent($kvel,$product->options->finishing_front)) $front_inline_varnish[$kvel] = $vel;
			if ($back_all || in_array_silent($kvel,$product->options->finishing_back)) $back_inline_varnish[$kvel] = $vel;
		}
		$front_offline_varnish = array();
		$back_offline_varnish = array();

		foreach($mod->finishingOfflineFull() as $kvel => $vel)
		{
			if ($front_all || in_array_silent($kvel,$product->options->finishing_front)) $front_offline_varnish[$kvel] = $vel;
			if ($back_all ||in_array_silent($kvel,$product->options->finishing_back)) $back_offline_varnish[$kvel] = $vel;
		}
		$front_varnish_set = array();
		$back_varnish_set = array();
		
		foreach($mod->list_vernis_combines as $kvel => $vel)
		{
			if ($front_all || in_array_silent($kvel,$product->options->finishing_front)) $front_varnish_set[$kvel] = $vel;
			if ($back_all ||in_array_silent($kvel,$product->options->finishing_back)) $back_varnish_set[$kvel] = $vel;
		}
		$smarty->assign(array('front_inline_varnish' => $front_inline_varnish,
								'back_inline_varnish' => $back_inline_varnish,
								'front_offline_varnish' => $front_offline_varnish,
								'back_offline_varnish' => $back_offline_varnish,
								'front_varnish_set' => $front_varnish_set,
								'back_varnish_set' => $back_varnish_set));
		return null;
		
	}
	
	public function finishingOptions() {
		return array(
			'OFFSET_BRILLANT' => array('kind' => 'Offset','finition' => 'BRILLANT','index' => 0, 'info' => $this->l('Gloss offset varnish')),
			'OFFSET_BRILLANT_RESERVE' => array('kind' => 'Offset','finition' => 'BRILLANT','reserve' => 50,'index' => 1, 'info' => $this->l('Spot gloss offset varnish')),

			'OFFSET_SATIN' => array('kind' => 'Offset','finition' => 'SATIN','index' => 2, 'info' => $this->l('vernis offset satin')),
			'OFFSET_SATIN_RESERVE' => array('kind' => 'Offset','finition' => 'SATIN','reserve' => 50,'index' => 3, 'info' => $this->l('Silk Mat offset varnish')),

			'OFFSET_MAT' => array('kind' => 'Offset','finition' => 'MAT','index' => 4, 'info' => $this->l('Mat offset varnish')),
			'OFFSET_MAT_RESERVE' => array('kind' => 'Offset','finition' => 'MAT','reserve' => 50,'index' => 5, 'info' => $this->l('Spot Mat offset varnish')),

			'ACRILY_BRILLANT' => array('kind' => 'Acrilyque','finition' => 'BRILLANT','index' => 6, 'info' => $this->l('Gloss dispersive varnish')),
			'ACRILY_BRILLANT_RESERVE' => array('kind' => 'Acrilyque','finition' => 'BRILLANT','reserve' => 30,'index' => 7, 'info' => $this->l('Gloss dispersive with space for stamp')),

			'ACRILY_SATIN' => array('kind' => 'Acrilyque','finition' => 'SATIN','roto?' => false,'index' => 8, 'info' => $this->l('Silk dispersive varnish ')),
			'ACRILY_SATIN_RESERVE' => array('kind' => 'Acrilyque','finition' => 'SATIN','reserve' => 30,'roto?' => false,'index' => 9, 'info' => $this->l('Silk dispersive varnish with space for stamp (sheetfed only)')),

			'ACRILY_MAT' => array('kind' => 'Acrilyque','finition' => 'MAT','roto?' => false,'index' => 10, 'info' => $this->l('Mat dispersive varnish (sheetfed only)')),
			'ACRILY_MAT_RESERVE' => array('kind' => 'Acrilyque','finition' => 'MAT','reserve' => 30,'roto?' => false,'index' => 11, 'info' => $this->l('Mat dispersive varnish with space for stamp (sheetfed only)')),

			'DRIPOFF' => array('kind' => 'DripOff', 'finition' => 'BRILLANT','index' => 12, 'info' => $this->l('drip off varnish')),

			'UVO_BRILLANT' => array('kind' => 'UvOffset','finition' => 'BRILLANT','index' => 13, 'info' => $this->l('Gloss offset UV varnish')),
			'UVO_BRILLANT_RESERVE' => array('kind' => 'UvOffset','finition' => 'BRILLANT','reserve' => 30,'index' => 14, 'info' => $this->l('Gloss offset UV varnish with space for stamp')),
			'UVO_SATIN' => array('kind' => 'UvOffset','finition' => 'SATIN','index' => 15, 'info' => $this->l('Silk UV offset varnish')),
			'UVO_SATIN_RESERVE' => array('kind' => 'UvOffset','finition' => 'SATIN','reserve' => 30,'index' => 16, 'info' => $this->l('Silk UV offset varnish with space for stamp')),
			'UVO_MAT' => array('kind' => 'UvOffset','finition' => 'MAT','index' => 17, 'info' => $this->l('Matt UV offset varnish')),
			'UVO_MAT_RESERVE' => array('kind' => 'UvOffset','finition' => 'MAT','reserve' => 30,'index' => 18, 'info' => $this->l('Matt UV offset varnish with space for stamp')),


			'UVN_BRILLANT_SELECTIF10' => array('kind' => 'UvNumerique','finition' => 'BRILLANT','reserve' => 10,'index' => 30, 'info' => $this->l('Spot glossy UV varnish < 10% - digital')),
			'UVN_BRILLANT_SELECTIF30' => array('kind' => 'UvNumerique','finition' => 'BRILLANT','reserve' => 30,'index' => 31, 'info' => $this->l('Spot glossy UV varnish < 30% - digital')),
			'UVN_BRILLANT_SELECTIF50' => array('kind' => 'UvNumerique','finition' => 'BRILLANT','reserve' => 50,'index' => 32, 'info' => $this->l('Spot glossy UV varnish > 30% - digital')),


			'UVS_BRILLANT' => array('kind' => 'UvSerigraphique','finition' => 'BRILLANT','index' => 40, 'info' => $this->l('Gloss screen varnish')),
			'UVS_SATIN' => array('kind' => 'UvSerigraphique','finition' => 'SATIN','index' => 41, 'info' => $this->l('Silk screen varnish')),
			'UVS_MAT' => array('kind' => 'UvSerigraphique','finition' => 'MAT','index' => 42, 'info' => $this->l('Mat screen varnish')),
																																			

			'UVS_BRILLANT_RESERVE' => array('kind' => 'UvSerigraphique','finition' => 'BRILLANT','reserve' => 70,'index' => 43, 'info' => $this->l('Spot gloss screen varnish (30%)')),
			'UVS_SATIN_RESERVE' => array('kind' => 'UvSerigraphique','finition' => 'SATIN','reserve' => 70,'index' => 44, 'info' => $this->l('Spot silk screen varnish (30%)')),
			'UVS_MAT_RESERVE' => array('kind' => 'UvSerigraphique','finition' => 'MAT','reserve' => 70,'index' => 45, 'info' => $this->l('Spot mat screen varnish (30%)')),

			'PELLIC_ACETATE_BRILLANT' => array('kind' => 'PelliculageAcetate','finition' => 'BRILLANT','index' => 33, 'info' => $this->l('Gloss acetate lamination')),
			'PELLIC_ACETATE_SATIN' => array('kind' => 'PelliculageAcetate','finition' => 'SATIN','index' => 34, 'info' => $this->l('Silk acetate lamination')),
			'PELLIC_ACETATE_MAT' => array('kind' => 'PelliculageAcetate','finition' => 'MAT','index' => 35, 'info' => $this->l('Mat acetate lamination ')),
			'PELLIC_POLYPRO_BRILLANT' => array('kind' => 'PelliculagePolypro','finition' => 'BRILLANT','index' => 36, 'info' => $this->l('Gloss polypro lamination')),
			'PELLIC_POLYPRO_SATIN' => array('kind' => 'PelliculagePolypro','finition' => 'SATIN','index' => 37, 'info' => $this->l('Silk polypro lamination')),
			'PELLIC_POLYPRO_MAT' => array('kind' => 'PelliculagePolypro','finition' => 'MAT','index' => 38, 'info' => $this->l('Mat polypro lamination')),
			'PELLIC_SOFT_TOUCH' => array('knid' => 'PelliculageSoftTouch','finition' => 'MAT','index' => 39, 'info' => $this->l('soft touch laminating')));
	}
	
	var $list_vernis_full = array(
		'OFFSET_BRILLANT','OFFSET_SATIN','OFFSET_MAT','OFFSET_BRILLANT_RESERVE','OFFSET_SATIN_RESERVE','OFFSET_MAT_RESERVE',
		'ACRILY_BRILLANT','ACRILY_SATIN','ACRILY_MAT','ACRILY_BRILLANT_RESERVE','ACRILY_SATIN_RESERVE','ACRILY_MAT_RESERVE',
		'DRIPOFF',
		'UVO_BRILLANT','UVO_SATIN','UVO_MAT','UVO_BRILLANT_RESERVE','UVO_SATIN_RESERVE','UVO_MAT_RESERVE',
		'UVS_BRILLANT','UVS_SATIN','UVS_MAT','UVS_BRILLANT_RESERVE','UVS_SATIN_RESERVE','UVS_MAT_RESERVE',
		'UVN_BRILLANT_SELECTIF10','UVN_BRILLANT_SELECTIF30','UVN_BRILLANT_SELECTIF50',
		'PELLIC_ACETATE_BRILLANT','PELLIC_ACETATE_SATIN','PELLIC_ACETATE_MAT', 
		'PELLIC_POLYPRO_BRILLANT','PELLIC_POLYPRO_SATIN','PELLIC_POLYPRO_MAT',
		'PELLIC_SOFT_TOUCH');
		

	var $list_vernis_combines = array(
		'PELLIC_ACETATE_BRILLANT+UVS_MAT_RESERVE' =>	array('PELLIC_ACETATE_BRILLANT','UVS_MAT_RESERVE'),
		'PELLIC_ACETATE_SATIN+UVS_BRILLANT_RESERVE' =>	array('PELLIC_ACETATE_SATIN','UVS_BRILLANT_RESERVE'),
		'PELLIC_ACETATE_MAT+UVS_BRILLANT_RESERVE' =>	array('PELLIC_ACETATE_MAT','UVS_BRILLANT_RESERVE'),

		'PELLIC_POLYPRO_BRILLANT+UVS_MAT_RESERVE' =>	array('PELLIC_POLYPRO_BRILLANT','UVS_MAT_RESERVE'),
		'PELLIC_POLYPRO_SATIN+UVS_BRILLANT_RESERVE' =>	array('PELLIC_POLYPRO_SATIN','UVS_BRILLANT_RESERVE'),
		'PELLIC_POLYPRO_MAT+UVS_BRILLANT_RESERVE' =>	array('PELLIC_POLYPRO_MAT','UVS_BRILLANT_RESERVE'),

		'OFFSET_BRILLANT+UVS_MAT_RESERVE' =>			array('OFFSET_BRILLANT','UVS_MAT_RESERVE'),
		'OFFSET_SATIN+UVS_BRILLANT_RESERVE' =>			array('OFFSET_SATIN','UVS_BRILLANT_RESERVE'),
		'OFFSET_MAT+UVS_BRILLANT_RESERVE' =>			array('OFFSET_MAT','UVS_BRILLANT_RESERVE'),

		'ACRILY_BRILLANT+UVS_MAT_RESERVE' =>			array('ACRILY_BRILLANT','UVS_MAT_RESERVE'),
		'ACRILY_SATIN+UVS_BRILLANT_RESERVE' =>			array('ACRILY_SATIN','UVS_BRILLANT_RESERVE'),
		'ACRILY_MAT+UVS_BRILLANT_RESERVE' =>			array('ACRILY_MAT','UVS_BRILLANT_RESERVE'),

		'ACRILY_BRILLANT+UVO_MAT_RESERVE' =>			array('ACRILY_BRILLANT','UVO_MAT_RESERVE'),
		'ACRILY_SATIN+UVO_BRILLANT_RESERVE' =>			array('ACRILY_SATIN','UVO_BRILLANT_RESERVE'),
		'ACRILY_MAT+UVO_BRILLANT_RESERVE' =>			array('ACRILY_MAT','UVO_BRILLANT_RESERVE'),

		'ACRILY_SATIN+UVN_BRILLANT_SELECTIF10' =>		array('ACRILY_SATIN','UVN_BRILLANT_SELECTIF10'),
		'ACRILY_SATIN+UVN_BRILLANT_SELECTIF30' =>		array('ACRILY_SATIN','UVN_BRILLANT_SELECTIF30'),
		'ACRILY_SATIN+UVN_BRILLANT_SELECTIF50' =>		array('ACRILY_SATIN','UVN_BRILLANT_SELECTIF50'),

		'PELLIC_POLYPRO_BRILLANT+ACRILY_MAT_RESERVE' =>	array('PELLIC_POLYPRO_BRILLANT','ACRILY_MAT_RESERVE'),
		'PELLIC_POLYPRO_SATIN+ACRILY_BRILLANT_RESERVE' =>	array('PELLIC_POLYPRO_SATIN','ACRILY_BRILLANT_RESERVE'),
		'PELLIC_POLYPRO_MAT+ACRILY_BRILLANT_RESERVE' =>	array('PELLIC_POLYPRO_MAT','ACRILY_BRILLANT_RESERVE'),

		'PELLIC_POLYPRO_MAT+UVN_BRILLANT_SELECTIF10' =>	array('PELLIC_POLYPRO_MAT','UVN_BRILLANT_SELECTIF10'),
		'PELLIC_POLYPRO_MAT+UVN_BRILLANT_SELECTIF30' =>	array('PELLIC_POLYPRO_MAT','UVN_BRILLANT_SELECTIF30'),
		'PELLIC_POLYPRO_MAT+UVN_BRILLANT_SELECTIF50' => array('PELLIC_POLYPRO_MAT','UVN_BRILLANT_SELECTIF50'));
	
	
	var $smartyok = false;
	public function registerSmartyPlugins()
	{
		if ($this->smartyok) return;
		smartyRegisterFunction(Context::getContext()->smarty,'modifier','infoFinishing',array($this,"infoFinishing"));
		smartyRegisterFunction(Context::getContext()->smarty,'function','ClariprintSetupFolds',array($this,"setupFolds"));
		smartyRegisterFunction(Context::getContext()->smarty,'function','ClariprintSetupFinishingOptions',array($this,"setupfinishingOptions"));
		
		$this->smartyok = true;
	}
	
	public function primaries() {
		return array('cyan' => $this->l('cyan'),
					'magenta' => $this->l('magenta'),
					'yellow' => $this->l('yellow'),
					'black' => $this->l('black'),
					'4-color' => $this->l('4-color'));
		
	}
	
	public function displayFrontProduct($id_product)
	{
		$config = $this->clariprintConfig($id_product);
		if ($config) {
			$id_customer = Context::getContext()->customer->id;
			if ($id_customer) $user_groups = Customer::getGroupsStatic($id_customer);
			else $user_groups = array();
			
			$product_kind = $this->current_config->product_kind;
			$this->smarty->assign(array(
				'product_template' => "./" . $product_kind .'.tpl',
				'product_key' => "clariprint_product",
				'product' => json_decode($this->current_config->product_json),
				'clariprint_product_id' => $id_product,
				
//				'vernis_en_lignes' => $this->finishinghInlineFull(),
//				'vernis_en_reprise' => $this->finishingOfflineFull(),
//				'vernis_combines' => $this->list_vernis_combines,

				'primary_colors' => array('cyan','magenta','yellow','black'),
				'sepcial_colors' => array('pms1','pms2','pms3','pms4'),
				'ajax_papers_selector_url' => '/index.php', //$this->context->link->getModuleLink('clariprint','paper'),
				'paper_kinds' => $this->paperKinds(),
				'user_groups' => $user_groups,
				'papers' => $this->getPapers(),
				'customer_addresses' => $this->getUserAddresses(),
				'deliveries' => $this->getDeliveriesOptions(),
				'wrapping' => $this->wrapping()));
			switch ($product_kind) {
				case "folded":
					$this->smarty->assign(array('folds' => $this->getFolds()));
					break;
				case "folder":
					$this->smarty->assign(array('folderdie' => $this->getFolderDie()));
					break;
			}
			
			$this->registerSmartyPlugins();

			error_reporting (E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_WARNING);		
			if ($product_kind <> "") {
				$this->smarty->error_reporting = E_ALL & ~E_NOTICE;
				$html .= $this->display(__FILE__, 'views/front/product.tpl');
			}
			return $html;
		} 
		return null;
	}
		
	public function hookDisplayFooterProduct($param)
	{
		return $this->displayFrontProduct(Tools::getValue('id_product'));
	}

	public function hookDisplayProductTabContent($param) {
		return $this->displayFrontProduct(Tools::getValue('id_product'));
	}

	static public function filterSimpleSizes($value='')
	{
		$res = array();
		$l = explode('\n',$value);
		foreach($l as $v) {
			$x = explode(":",$v);
			$res[$x] = end($x);
		}
		return $res;
	}

	public function productTypes()
	{
		return array("leaflet" => $this->l("Leaflet"),
					"folded" => $this->l("Folded leaflet"),
					"folder" => $this->l("Folder"),
					"simplebook" => $this->l("Simple book"),
					"book" => $this->l("Book"));
	}
	
	public function hookDisplayAdminProductsExtra($cookie,$car=null,$altern=null)
	{
		$this->context->controller->addCSS(($this->_path).'clariprint.css', 'all');
		Logger::addLog("hookDisplayAdminProductsExtra");
		
		$id_product = Tools::getValue('id_product');
		
		$cfg  = Clariprint_Config::loadByIdProduct($id_product);
		$product_kind = "";
		if ($cfg) $product_kind = $cfg->product_kind;
		$this->smarty->assign(array(
						'presta_product' => new Product($id_product),
						'productkinds' => $this->productTypes(),
						'product_key' => "clariprint_product"));
		if ($prod = $cfg->product())
			$this->smarty->assign(array('product' => $prod));
		if ($product_kind)
			$product_template =  "./" . $product_kind .'.tpl';
		else $product_template = false;
		
		
		$this->smarty->assign(array('vernis_en_lignes' => $this->finishinghInlineFull(),
									'vernis_en_reprise' => $this->finishingOfflineFull(),
									'vernis_combines' => $this->list_vernis_combines,
									'paper_kinds' => $this->paperKinds(),
									'papers' => $this->getPapers(),
									'product_template' => $product_template,
//									'customer_addresses' => $this->getUserAddresses(),
									'deliveries' => $this->getDeliveriesOptions(),
									'wrapping' => $this->wrapping(),
									'primaries' => $this->primaries(),
									'groups' => Group::getGroups(Context::getContext()->language->id),
									'ajax_papers_selector_url' => '/index.php', // $this->context->link->getModuleLink('clariprint','paper')
									'ajax_papers_selector_url2' => $this->context->link->getModuleLink('clariprint','paper') 
								 								));
		
		switch ($product_kind) {
			case "folded":
				$this->smarty->assign(array('folds' => $this->getFolds()));
				break;
			case "folder":
				$this->smarty->assign(array('folderdie' => $this->getFolderDie()));
				break;
					
		}

		$this->registerSmartyPlugins();

		error_reporting (E_ALL & ~E_NOTICE & ~E_DEPRECATED & ~E_WARNING);		

			$this->smarty->error_reporting = E_ALL & ~E_NOTICE;
	        $html .= $this->display(__FILE__, 'views/admin/product.tpl');
			return $html;
	}
	
	
	public function in_array($x,$arr) {
		if ($arr) {
			in_array($x,$arr);
		}
		return false;
	}
	
	public function hookActionProductUpdate($params) {
        $clariprint_product_kind = Tools::getValue('clariprint_product_kind');
		$id_product = Tools::getValue('id_product');
		
		
		if ($clariprint_product_kind == '') {
			Clariprint_Config::deleteForProductId($id_product);
		} else {
			$cfg = Clariprint_Config::loadByIdProduct($id_product);
			$cfg->product_kind = $clariprint_product_kind;
			$cfg->product_id = $id_product;
			
			$product = Tools::getValue("clariprint_product");
			$product['kind'] = $clariprint_product_kind;
			$cfg->product_json = json_encode($product);
			
			if (isset($cfg->id))
			{	if (!$cfg->update()) throw new PrestaShopException('Cannot update clariprint setup'); }
			elseif(!$cfg->add()) throw new PrestaShopException('Cannot create clariprint setup');
		}
	}

	public function hookDisplayAdminCustomers($params) {
		return null;
		
		$id_customer = (int)$params['id_customer'];
		$group = ClariprintCategory::getGroup($id_customer);
		
		$custo = new Customer($id_customer);
		$category = null;
		$group_id = 0;
		if ($group) ClariprintCategory::getGroupCategory($group->id);
		if ($group) $group_id = $group->id;
		
		$x = '<div style="width:100%"><h2>Clariprint setup</h2>';
		$x .= '<label for="clariprint_url">'.$this->l('Group:').'</label>';
		$groups = $custo->getGroups();
		
		
		$x .= '<select name="clariprint_group">';
		$x .= '<option value="0">-</option>';
				
		foreach($groups as $gid)
		{
			$g = new Group($gid); 
			$sel = ($group_id == $g->id ? ' selected' : '');
			$x .= sprintf('<option value="%d"%s>%s</option>',$g->id,$sel,$g->name[$this->context->language->id]);
		}
		$x .= '</select>';
		$x .= '<input type="submit" name="clariprint_create_group" value="'. $this->l("Create") .'" />';
		$x .= '<input type="submit" name="clariprint_update" value="'. $this->l("Update") .'" />';
		$x .= '<hr>';
		$x .= '</form>';  
		$x .= '</div>';

		return $x;
	}
	
	
	
	public function ajaxProcessUpdateClariprintClientConfig()
	{
		
/*		if ($this->tabAccess['edit'] === '1')
		{
			$note = Tools::htmlentitiesDecodeUTF8(Tools::getValue('note'));
			$customer = new Customer((int)Tools::getValue('id_customer'));
			if (!Validate::isLoadedObject($customer))
				die ('error:update');
			if (!empty($note) && !Validate::isCleanHtml($note))
				die ('error:validation');
			$customer->note = $note;
			if (!$customer->update())
				die ('error:update');
			die('ok');
		} */
	}
	
	public function hookActionOrderStatusPostUpdate($param) {
		$cart = $param['cart'];
		$status = $param['newOrderStatus'];
		$order = new Order($param['id_order']);
		$mailVars = array(
			'{order_id}' => 12,
				'{order_id}' => 12
			
		);
		if ($status->id == 2)
			Mail::Send((int)$cart->id_lang, 'clariprint_workflow_fab','test',
				$mailVars,
				'x@pechoultres.com',
				$customer->firstname.' '.$customer->lastname,
				null, null, null, null, _PS_MAIL_DIR_, true,
				null);
	}
	
	static function addTableColumn($table, $column, $column_attr = "VARCHAR( 255 ) NULL" ){
		$result = Db::getInstance()->executeS(sprintf('show columns from %s%s',_DB_PREFIX_,$table));
		foreach($result as $col) {
			if ($col['Field'] == $column) {
				return;
			}
		}
		Db::getInstance()->execute(sprintf('ALTER TABLE %s%s ADD COLUMN %s %s',_DB_PREFIX_,$table,$column, $column_attr));
	}
	
	private function runUpdates()
	{
		$up_path = _PS_MODULE_DIR_.'clariprint/updates/';
		$current_version  = Configuration::get('CL_DB_VERSIONS');

		$files = glob($up_path . '[0-9]*.php');
		foreach($files as $f) {
			$fname = basename($f);
			$val = (int)$fname;
			if ($val > $current_version)
			{
				try {
					include($f);
					$this->_confirmations[] = "runnning $fname : ok<br>";
					Configuration::updateValue('CL_DB_VERSIONS', $val);
				} catch (Exception $e) {
					$this->_errors[] = 'Error on '. $fname . ' : '. $e->getMessage();
					return;
				}
			}
		}
		$this->_confirmations[] = 'Current clariprint db version : '. Configuration::get('CL_DB_VERSIONS') ;
	}
	
	
	
	
	
	
	public function getUserAddresses()
	{
		if (!Context::getContext()->customer->isLogged()) return array();

		$id_customer = Context::getContext()->customer->id;
		$sql = 'SELECT DISTINCT a.*, s.name AS state, c.iso_code AS country_iso, s.iso_code AS state_iso
					FROM `'._DB_PREFIX_.'address` a
					LEFT JOIN `'._DB_PREFIX_.'country` c ON (a.`id_country` = c.`id_country`)
					LEFT JOIN `'._DB_PREFIX_.'state` s ON (s.`id_state` = a.`id_state`)
					WHERE a.active = 1  AND `id_customer` = '.(int)$id_customer.' AND a.`deleted` = 0';


		$res = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);
		
		
		return $res;
	}
	
}

